/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.alipay;

import cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext.alipay.AlipayActivityAutoCreateExtInfoDto;
import cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext.alipay.CardPayCutAutoCreateExtInfoDto;
import cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext.alipay.GeneralCouponAutoCreateExtInfoDto;
import cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay.DiscountTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay.GamePlaySingleTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay.RedEnableTimeTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay.SendLimitTypeEnum;
import cn.com.duiba.quanyi.center.api.utils.PriceUtils;
import cn.com.duiba.quanyi.center.api.utils.StringUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AlipayActivityAutoCreateUtils {
    private static final Logger log = LoggerFactory.getLogger(AlipayActivityAutoCreateUtils.class);
    private static final String JOINER = "-";
    private static final long FIVE_THOUSANDS_CENT = 5000L;
    private static final int ALARM_APP_ID_LIMIT = 10;
    private static final int ALARM_PHONE_LIMIT = 3;

    public static Long calTotalAmount(Long budgetAmount, Long couponAmount, String startDate, String endDate, Long maxLimitAmount, boolean autoAddMoney) {
        if (!autoAddMoney) {
            return budgetAmount;
        }
        long initAmount = budgetAmount / (long)AlipayActivityAutoCreateUtils.calDiffDays(startDate, endDate).intValue() * 10L;
        initAmount += couponAmount - initAmount % couponAmount;
        if (maxLimitAmount == null) {
            return Math.min(Math.max(initAmount, 5L * couponAmount), budgetAmount);
        }
        return Math.min(Math.max(Math.max(initAmount, 5L * couponAmount), maxLimitAmount), budgetAmount);
    }

    private static Integer calDiffDays(String startDate, String endDate) {
        return DateUtils.daysBetween((Date)DateUtils.getDayDate((String)startDate), (Date)DateUtils.getDayDate((String)endDate)) + 1;
    }

    public static List<AlipayActivityAutoCreateExtInfoDto.Bank> parseBankList(String bankListStr) {
        if (StringUtils.isBlank((CharSequence)bankListStr)) {
            return Collections.emptyList();
        }
        List<String> bankStrList = StringUtil.splitStringWithComma(bankListStr);
        return bankStrList.stream().map(AlipayActivityAutoCreateUtils::parseBank).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static AlipayActivityAutoCreateExtInfoDto.Bank parseBank(String bankStr) {
        List<String> bankNameAndBankCardType = StringUtil.splitStringWithSeparator(bankStr, JOINER);
        if (CollectionUtils.isEmpty(bankNameAndBankCardType)) {
            return null;
        }
        AlipayActivityAutoCreateExtInfoDto.Bank bank = new AlipayActivityAutoCreateExtInfoDto.Bank();
        bank.setName(bankNameAndBankCardType.get(0));
        bank.setCardType(Integer.valueOf(bankNameAndBankCardType.get(1)));
        return bank;
    }

    public static AlipayActivityAutoCreateExtInfoDto.EnableTime parseEnableTime(String weeks, String times) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{weeks, times})) {
            return null;
        }
        AlipayActivityAutoCreateExtInfoDto.EnableTime enableTime = new AlipayActivityAutoCreateExtInfoDto.EnableTime();
        enableTime.setWeeks(StringUtil.splitIntegerWithComma(weeks));
        enableTime.setTimes(StringUtil.splitStringWithComma(times));
        return enableTime;
    }

    public static AlipayActivityAutoCreateExtInfoDto.Alarm parseAlarm(String alarmAmount, String alarmPhone) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{alarmAmount, alarmPhone})) {
            return null;
        }
        AlipayActivityAutoCreateExtInfoDto.Alarm alarm = new AlipayActivityAutoCreateExtInfoDto.Alarm();
        alarm.setAmount(alarmAmount);
        alarm.setPhoneList(StringUtil.splitStringWithComma(alarmPhone));
        return alarm;
    }

    public static CardPayCutAutoCreateExtInfoDto.DayBudget parseDayBudget(Integer dayBudgetType, String dayBudgetAmount) {
        if (dayBudgetType == null || StringUtils.isBlank((CharSequence)dayBudgetAmount)) {
            return null;
        }
        CardPayCutAutoCreateExtInfoDto.DayBudget dayBudget = new CardPayCutAutoCreateExtInfoDto.DayBudget();
        dayBudget.setAmount(dayBudgetAmount);
        dayBudget.setType(dayBudgetType);
        return dayBudget;
    }

    public static CardPayCutAutoCreateExtInfoDto.GamePlaySingle parseGamePlaySingle(Integer gamePlaySingleType, String gamePlaySingleMaxAmount, String gamePlaySingleThreshold, String gamePlaySingleAveragePrice, String gamePlaySingleAverage, String gamePlaySingleRule) {
        if (GamePlaySingleTypeEnum.getByType(gamePlaySingleType) == null) {
            return null;
        }
        CardPayCutAutoCreateExtInfoDto.GamePlaySingle gamePlaySingle = new CardPayCutAutoCreateExtInfoDto.GamePlaySingle();
        gamePlaySingle.setType(gamePlaySingleType);
        gamePlaySingle.setThreshold(gamePlaySingleThreshold);
        if (GamePlaySingleTypeEnum.FIXED_REDUCE.getType().equals(gamePlaySingleType)) {
            gamePlaySingle.setAmount(gamePlaySingleRule);
        }
        if (GamePlaySingleTypeEnum.DISCOUNT_REDUCE.getType().equals(gamePlaySingleType)) {
            gamePlaySingle.setRule(gamePlaySingleRule);
            gamePlaySingle.setMaxAmount(gamePlaySingleMaxAmount);
        }
        if (GamePlaySingleTypeEnum.SMART_REDUCE.getType().equals(gamePlaySingleType)) {
            gamePlaySingle.setAverage(StringUtil.splitStringWithSeparator(gamePlaySingleAverage, JOINER));
            gamePlaySingle.setAveragePrice(gamePlaySingleAveragePrice);
        }
        return gamePlaySingle;
    }

    public static CardPayCutAutoCreateExtInfoDto.GamePlayStep parseGamePlayStep(String gamePlayStepRule, String gamePlayStepMaxAmount) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{gamePlayStepRule, gamePlayStepMaxAmount})) {
            return null;
        }
        CardPayCutAutoCreateExtInfoDto.GamePlayStep gamePlayStep = new CardPayCutAutoCreateExtInfoDto.GamePlayStep();
        gamePlayStep.setMaxAmount(gamePlayStepMaxAmount);
        gamePlayStep.setArray(StringUtil.splitStringWithComma(gamePlayStepRule).stream().map(rule -> {
            List<String> rules = StringUtil.splitStringWithSeparator(rule, JOINER);
            CardPayCutAutoCreateExtInfoDto.GamePlayRule gamePlayRule = new CardPayCutAutoCreateExtInfoDto.GamePlayRule();
            gamePlayRule.setThresholdArea(Lists.newArrayList((Object[])new String[]{rules.get(0), rules.get(1)}));
            gamePlayRule.setType(Integer.parseInt(rules.get(2)));
            gamePlayRule.setRule(rules.get(3));
            return gamePlayRule;
        }).collect(Collectors.toList()));
        return gamePlayStep;
    }

    public static List<AlipayActivityAutoCreateExtInfoDto.TimeLimit> parseTimeLimit(String timeLimitStr) {
        if (StringUtils.isBlank((CharSequence)timeLimitStr)) {
            return null;
        }
        List<String> timeLimits = StringUtil.splitStringWithComma(timeLimitStr);
        if (CollectionUtils.isEmpty(timeLimits)) {
            return null;
        }
        return timeLimits.stream().map(timeLimitSingleStr -> {
            AlipayActivityAutoCreateExtInfoDto.TimeLimit timeLimit = new AlipayActivityAutoCreateExtInfoDto.TimeLimit();
            List<Integer> timeLimitSingle = StringUtil.splitIntegerWithSeparator(timeLimitSingleStr, JOINER);
            timeLimit.setType(timeLimitSingle.get(0));
            timeLimit.setNum(timeLimitSingle.get(1));
            return timeLimit;
        }).collect(Collectors.toList());
    }

    public static boolean isValidAlarm(AlipayActivityAutoCreateExtInfoDto.Alarm alarm, long totalAmount) {
        if (alarm == null) {
            return true;
        }
        if (alarm.getAmount() == null) {
            return false;
        }
        if (alarm.getPhoneList() == null && alarm.getAppidList() == null) {
            return false;
        }
        long alarmAmount = PriceUtils.convertY2F(alarm.getAmount());
        if (alarmAmount < 5000L || alarmAmount < totalAmount) {
            return false;
        }
        if (CollectionUtils.isNotEmpty(alarm.getAppidList()) && alarm.getAppidList().size() > 10) {
            return false;
        }
        return CollectionUtils.isNotEmpty(alarm.getPhoneList()) && alarm.getPhoneList().size() > 3;
    }

    public static GeneralCouponAutoCreateExtInfoDto.RedEnableTime parseRedEnableTime(Integer type, Integer validDays, String startTime, String endTime) {
        RedEnableTimeTypeEnum enableTimeTypeEnum = RedEnableTimeTypeEnum.getByType(type);
        if (enableTimeTypeEnum == null) {
            return null;
        }
        GeneralCouponAutoCreateExtInfoDto.RedEnableTime redEnableTime = new GeneralCouponAutoCreateExtInfoDto.RedEnableTime();
        if (RedEnableTimeTypeEnum.IMMEDIATELY.equals((Object)enableTimeTypeEnum) || RedEnableTimeTypeEnum.NEXT_DAY.equals((Object)enableTimeTypeEnum)) {
            redEnableTime.setType(type);
            redEnableTime.setInvalidDays(validDays);
            return redEnableTime;
        }
        redEnableTime.setInvalidTimeRange(Lists.newArrayList((Object[])new String[]{startTime, endTime}));
        return redEnableTime;
    }

    public static GeneralCouponAutoCreateExtInfoDto.SendLimit parseSendLimit(Integer sendType, Integer sendControlType, String sendControlContent, String apiPermission, Integer isOverlay, Integer isSpecial, List<Integer> multipleSpecialScene) {
        SendLimitTypeEnum typeEnum = SendLimitTypeEnum.getByType(sendType);
        if (typeEnum == null) {
            return null;
        }
        GeneralCouponAutoCreateExtInfoDto.SendLimit sendLimit = new GeneralCouponAutoCreateExtInfoDto.SendLimit();
        sendLimit.setSendType(sendType);
        sendLimit.setSendControlType(sendControlType);
        sendLimit.setSendControlContent(sendControlContent);
        sendLimit.setApiPermission(StringUtil.splitStringWithComma(apiPermission));
        sendLimit.setIsOverlay(isOverlay);
        sendLimit.setIsSpecial(isSpecial);
        sendLimit.setMultipleSpecialScene(multipleSpecialScene);
        return sendLimit;
    }

    public static GeneralCouponAutoCreateExtInfoDto.DiscountInfo parseDiscountInfo(Integer discountType, String discountAmount, String discountThreshold) {
        DiscountTypeEnum typeEnum = DiscountTypeEnum.getByType(discountType);
        if (typeEnum == null || StringUtils.isBlank((CharSequence)discountThreshold) || StringUtils.isBlank((CharSequence)discountAmount)) {
            return null;
        }
        GeneralCouponAutoCreateExtInfoDto.DiscountInfo discountInfo = new GeneralCouponAutoCreateExtInfoDto.DiscountInfo();
        discountInfo.setType(discountType);
        discountInfo.setThreshold(discountThreshold);
        if (DiscountTypeEnum.FIXED_AMOUNT_DISCOUNT.equals((Object)typeEnum)) {
            discountInfo.setDiscountAmount(discountAmount);
        } else {
            discountInfo.setDiscountReduceRange(StringUtil.splitStringWithSeparator(discountAmount, JOINER));
        }
        return discountInfo;
    }
}

