package cn.com.duiba.quanyi.center.api.remoteservice.insurance.verify;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.insurance.verify.InsuranceVerifyPolicyRecordDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceVerifyPolicyRecordSearchParam;

import java.util.List;

/**
 * 权益保单验真记录表
 * @author kjj mybatis generator 
 * @date 2024-03-14
 */
@AdvancedFeignClient
public interface RemoteInsuranceVerifyPolicyRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 权益保单验真记录集合
     */
    List<InsuranceVerifyPolicyRecordDto> selectPage(InsuranceVerifyPolicyRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceVerifyPolicyRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 权益保单验真记录
     */
    InsuranceVerifyPolicyRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 权益保单验真记录
     * @return 执行结果
     */
    int insert(InsuranceVerifyPolicyRecordDto dto);

    /**
     * 更新
     * @param dto 权益保单验真记录
     * @return 影响行数
     */
    int update(InsuranceVerifyPolicyRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量新增
     * @param list 保单验真上传记录
     * @return 执行结果
     */
    int batchInsert(List<InsuranceVerifyPolicyRecordDto> list);

    /**
     * 根据唯一键批量查询
     * @param companyId 公司id
     * @param carPolicyNos 车险单号集合
     * @param nonCarPolicyNos 非车险单号集合
     * @return
     */
    List<InsuranceVerifyPolicyRecordDto> selectByUks(Long companyId, List<String> carPolicyNos, List<String> nonCarPolicyNos);
}