package cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/4/17 15:07
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class FirstBindAutoCreateExtInfoDto extends WxCouponAutoCreateExtInfoDto {
    private static final long serialVersionUID = 2490586883024349515L;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 活动名称
     */
    private String stockName;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 银行卡类型 1-借记卡 2-信用卡
     */
    private Integer bankCardType;

    /**
     * 卡片名称
     */
    private String bankCardName;

    /**
     * 卡bin号列表，逗号分割
     */
    private List<String> cardBinList;

    /**
     * 主题色
     */
    private Integer themeColor;

    /**
     * 立减金名称
     */
    private String discountName;

    /**
     * 门槛金额（元）
     */
    private String discountMax;

    /**
     * 优惠金额（元）
     */
    private String discountAmount;

    /**
     * 开始日期 yyyy-MM-dd
     */
    private String startDate;

    /**
     * 结束日期 yyyy-MM-dd
     */
    private String endDate;

    /**
     * 领券后几天内可用 可用天数必须小于等于券有效期，不传表示有效期内任意时间可用
     */
    private Integer canUseDay;

    /**
     * 使用规则
     */
    private String useRule;

    /**
     * 同时使用 1-叠加使用 2-互斥试用
     */
    private Integer bothUse;

    /**
     * 活动开始时间
     */
    private String activityStartDate;

    /**
     * 活动结束时间
     */
    private String activityEndDate;

    /**
     * 活动预算
     */
    private String budgetAmount;

    /**
     * 单日发放上限金额（元）
     */
    private String dayLimitAmount;

    /**
     * 是否限制投放渠道（0-不限制投放渠道 1-限制投放渠道）
     */
    private Integer limitBindChannel;

    /**
     * 投放渠道（1-微信端 2-一键绑卡 3-绑卡码）
     */
    private List<Integer> bindChannels;

    /**
     * 场景值匹配类型（投放渠道选择绑卡码选填）
     * 1-精准匹配
     * 2-模糊匹配
     */
    private Integer sceneMatchType;

    /**
     * 场景值（投放渠道选择绑卡码选填，多个英文逗号分割，最多输入100个）
     */
    private List<String> sceneList;
}
