package cn.com.duiba.quanyi.center.api.enums.icbc.jx;


import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 江西工行-奖品类型
 * (credit-信用卡，debit-借记卡)
 * @author lyj
 */
@Getter
@AllArgsConstructor
public enum IcbcPrizeTypeEnum {

    CREDIT("credit", "信用卡"),
    DEBIT("debit", "借记卡");

    public static IcbcPrizeTypeEnum getByCode(String code) {
        for (IcbcPrizeTypeEnum typeEnum : values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }

    private String code;
    private String desc;
}
