package cn.com.duiba.quanyi.center.api.dto.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 活动奖品表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@Data
public class ActivityPrizeDto implements Serializable {

    private static final long serialVersionUID = 7513946728797932003L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品图
     */
    private String prizeImg;

    /**
     * 奖品背景图
     */
    private String prizeBackGroundImg;

    /**
     * 活动主键, tb_activity.id
     */
    private Long activityId;

    /**
     * 商品ID
     */
    private Long spuId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 面额，类型为微信立减金时，必填
     */
    private Long amount;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 发放方式
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderGrantTypeEnum
     */
    private Integer grantType;

    /**
     * 面额类型：1-固定，2-不固定
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum#getType()
     */
    private Integer amountType;

    /**
     * 不固定面额：最小面额，单位分
     */
    private Long rangeMinAmount;

    /**
     * 不固定面额：最大面额，单位分
     */
    private Long rangeMaxAmount;

    /**
     * 限定周期可领：0-不限定，1-限定
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum#getCode()
     */
    private Integer takeDuringLimitType;

    /**
     * 限定周期：起始时间
     */
    private Date takeDuringStart;

    /**
     * 限定周期：结束时间
     */
    private Date takeDuringEnd;

    /**
     * 扩展信息
     */
    private List<ActivityPrizeExtDto> activityPrizeExtDtos;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 奖品类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityPrizeTypeEnum
     */
    private Integer prizeType;

    /**
     * 父级奖品ID
     */
    private Long parentPrizeId;
}