package cn.com.duiba.quanyi.center.api.dto.goods;

import cn.com.duiba.quanyi.center.api.enums.api.ApiSpecTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * @author xuzhigang
 * @date 2024/6/28 10:22
 **/
@Data
public class GoodsOrderEsDto implements Serializable {
    private static final long serialVersionUID = 4483968610304475701L;

    /**
     * 商品订单id
     */
    private Long goodsOrderId;

    /**
     * 订单号
     */
    private String goodsOrderNo;

    /**
     * 创建时间 yyyy-MM-dd HH:mm:ss
     * tb_goods_order.gmt_create
     */
    private String gmtCreate;

    /**
     * 业务单号
     */
    private String bizOrderNo;

    /**
     * tb_order.order_no
     */
    private String orderNo;

    /**
     * 商品库订单业务主键
     */
    private Long goodsBizId;

    /**
     * 商品库订单业务类型, 1-白名单活动，2-商品包
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum
     */
    private Integer goodsBizType;

    /**
     * 用户id
     * tb_goods_order.user_id
     */
    private Long userId;

    /**
     * 供应商id
     * tb_order.supplier_id
     */
    private Long supplierId;

    /**
     * 商品名称
     * tb_activity_prize.prize_name or tb_goods_pkg.goods_pkg_name
     */
    private String goodsName;

    /**
     * 活动名称
     * tb_activity.activity_name or tb_goods_pkg.goods_pkg_name
     */
    private String activityName;

    /**
     * 活动类型
     * tb_goods_order.activity_type
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     */
    private Integer activityType;

    /**
     * 订单状态
     * tb_goods_order.order_status
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 客户订单号
     * tb_api_order.third_order_id
     */
    private String thirdOrderId;

    /**
     * 兑吧订单号
     * tb_api_order.main_order_num
     */
    private String mainOrderNum;

    /**
     * 客户名称
     * tb_partner.partner_name
     */
    private String partnerName;

    /**
     * 对接id
     * tb_api_joint_config.id
     */
    private Long apiJointId;

    /**
     * 券码
     * tb_code.coupon_code
     */
    private String couponCode;

    /**
     * 券链接
     * tb_code.link
     */
    private String couponLink;

    /**
     * 支付订单号
     * tb_pay_order.biz_order_no
     */
    private String payOrderNo;

    /**
     * 用户手机号
     * tb_activity_prize_receive_record.user_phone
     */
    private String userPhone;

    /**
     * 商城订单号
     * tb_mall_order.mall_order_no
     */
    private String mallOrderNo;

    /**
     * 商品库商品id
     * tb_spu.id
     */
    private Long spuId;

    /**
     * 商品sku id
     * tb_sku.id
     */
    private Long skuId;

    /**
     * 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 活动id
     * tb_activity.id
     */
    private Long activityId;

    /**
     * 奖品id
     * tb_activity_prize.id
     */
    private Long prizeId;

    /**
     * 需求id
     * tb_demand.id
     */
    private Long demandId;

    /**
     * 合同id
     * tb_contract.id
     */
    private Long contractId;

    /**
     * 客户id
     * tb_partner.id
     */
    private Long partnerId;

    /**
     * 渠道id
     * tb_goods_pkg_channel.id
     */
    private Long goodsPkgChannelId;

    /**
     * 调用单号
     * tb_channel_order.out_biz_no
     */
    private Set<String> outBizNoList;

    /**
     * 权益发放时间
     * tb_order.gmt_create
     */
    private String grantTime;

    /**
     * 商品类型 tb_api_order.spec_type
     *
     * @see ApiSpecTypeEnum#getType()
     */
    private Integer specType;
}
