package cn.com.duiba.quanyi.center.api.dto.mall.order;

import lombok.Data;

import java.io.Serializable;

/**
 * 商城订单直充类型领取参数（实物除外）
 *
 * @author wangguanhua
 */
@Data
public class MallOrderTakeParamDto implements Serializable {

    private static final long serialVersionUID = -1332273439364795841L;

    /**
     * 支付宝用户id，可通过支付宝授权方式获取
     */
    private String alipayUserId;

    /**
     * 支付宝openId, 映射支付宝user_id
     * 请使用open_id，后续user_id将不支持新接入使用，存量已对接的也将逐步回收。
     */
    private String alipayOpenId;

    /**
     * 支付宝登录账号，邮箱格式
     */
    private String alipayLoginId;

    /**
     * 支付宝登录账号，手机号格式
     */
    private String alipayPhoneId;

    /**
     * 充值手机号
     * 爱奇艺、腾讯会员
     */
    private String phone;

    /**
     * 充值账号
     * ● 商品为油卡时有值
     */
    private String account;

    /**
     * 充值qq号
     */
    private String qqAccount;

    /**
     * 车牌号 商品类型为车服必填
     */
    private String carNumber;

    /**
     * 门店服务id，汽车服务时必填
     */
    private Long storeSerId;

    /**
     * 汽车服务名称
     */
    private String carSerName;

    /**
     * 门店id，汽车服务时必填
     */
    private Long storeId;

    /**
     * 平台类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.car.CarSerPlatformTypeEnum
     */
    private Integer platformType;

}