package cn.com.duiba.quanyi.center.api.dto.mall.page;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 商城页面区域配置
 * @author mybatis generator 
 * @date 2024-05-23
 */
@Data
public class MallPageRegionConfDto implements Serializable {
     
    private static final long serialVersionUID = 17164469108712079L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 页面区域Id
     */
    private Long pageRegionId;

    /**
     * 页面ID
     */
    private Long pageId;

    /**
     * 页面区域
     * @see cn.com.duiba.quanyi.center.api.enums.mall.MallPageRegionEnum
     */
    private Integer pageRegion;

    /**
     * 配置名称
     */
    private String confName;

    /**
     * 配置图片
     */
    private String confImgs;

    /**
     * 链接类型：1-商品详情页，2-h5链接，3-小程序链接，4-二级页面
     * @see cn.com.duiba.quanyi.center.api.enums.mall.MallLinkTypeEnum
     */
    private Integer linkType;

    /**
     * 商城商品Id
     */
    private Long mallSpuId;

    /**
     * 领取类型，1-积分兑换，2-现金支付
     * @see cn.com.duiba.quanyi.center.api.enums.mall.MallTakeTypeEnum
     */
    private Integer takeType;

    /**
     * h5链接
     */
    private String h5Link;

    /**
     * 小程序appId
     */
    private String mpAppId;

    /**
     * 小程序跳转path
     */
    private String mpPagePath;

    /**
     * 关联页面ID
     */
    private Long linkPageId;

    //*************** 商品信息 ****************

    /**
     * 商品名称
     */
    private String mallSpuName;

    /**
     * 最低划线价，单位分
     */
    private Long minMarketPrice;

    /**
     * 最高划线价，单位分
     */
    private Long maxMarketPrice;

    /**
     * 最低售卖价，单位分
     */
    private Long minSellPrice;

    /**
     * 最高售卖价，单位分
     */
    private Long maxSellPrice;

    /**
     * 最低兑换价，单位分
     */
    private Long minTakePrice;

    /**
     * 最高兑换价，单位分
     */
    private Long maxTakePrice;

    /**
     * 商品类型
     * {@link cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum}
     */
    private Integer spuType;
}