package cn.com.duiba.quanyi.center.api.param;

import lombok.Data;

import java.io.Serializable;

/**
 * 上传任务保存
 * @author lizhi
 * @date 2023/3/29 4:26 PM
 */
@Data
public class UploadTaskUpdateResultParam implements Serializable {

    private static final long serialVersionUID = 6881266156086555707L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 上传总数
     */
    private Integer totalCount;

    /**
     * 上传失败数量
     */
    private Integer failureCount;

    /**
     * 上传成功数量
     */
    private Integer successCount;

    /**
     * 失败文件地址
     */
    private String failureFileUrl;

    /**
     * 任务状态 0-初始化 1-上传中 2-上传失败(系统报错) 3-上传完成
     * {@link cn.com.duiba.quanyi.center.api.enums.UploadTaskStatusEnum}
     */
    private Integer taskStatus;

    /**
     * 失败原因
     */
    private String failMsg;
    
}
