package cn.com.duiba.quanyi.center.api.param.bank.zjbank;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 浙江建行核销明细表
 * @author mybatis generator 
 * @date 2024-07-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class CcbZjHxBillDetailSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17216377800058962L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 客户活动类型
     */
    private String customActivityType;

    /**
     * 活动ID
     */
    private String actId;

    /**
     * 活动名称
     */
    private String actName;

    /**
     * 活动类型
     */
    private String actType;

    /**
     * 核销日期
     */
    private Date consumeTime;

    /**
     * 红包核销面额（单位：分）
     */
    private Long discountAmount;

    /**
     * 订单金额（单位：分）
     */
    private Long totalAmount;

    /**
     * 实付金额（单位：分）
     */
    private Long payAmount;

    /**
     * 银行流水号
     */
    private String bankSerialNum;

    /**
     * 支付宝交易号
     */
    private String payOrderNum;

    /**
     * 商家PID
     */
    private String consumeMchPid;

    /**
     * 商家名称
     */
    private String consumeMchName;

    /**
     * 预充值方式
     */
    private String preRechargeType;

    /**
     * 门店ID
     */
    private String consumeMchId;

    /**
     * 门店名称
     */
    private String consumeMchStoreName;

    /**
     * 券ID
     */
    private String voucherId;

    /**
     * 券模板ID
     */
    private String couponTemplateId;

    /**
     * 卡号前6位
     */
    private String cardNumTop6;

    /**
     * 商圈名称
     */
    private String cbdName;

    /**
     * 商圈门店名称
     */
    private String cbdStoreName;

    /**
     * 账单日期（yyyy-MM-dd）
     */
    private LocalDate billDate;

    /**
     * 是否上传：0-未上传，1-已上传
     * {@link cn.com.duiba.quanyi.center.api.enums.BizStatusEnum}
     */
    private Integer bizStatus;

    /**
     * 额外信息
     */
    private String extra;
}