package cn.com.duiba.quanyi.center.api.param.ccbLife;

import cn.com.duiba.quanyi.center.api.param.PageQuery;

import java.io.Serializable;
import java.util.Set;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author xjl
 * @date 2023/11/24 14:07
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class BusinessMonthPageQueryParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = -130770181414188345L;

    /**
     * 商户号
     */
    private String businessNum;

    /**
     * 门店号
     */
    private String shopNum;

    /**
     * 商户名
     */
    private String businessName;

    /**
     * 门店名
     */
    private String shopName;

    /**
     * 结算月份:开始
     */
    private Long monthBegin;

    /**
     * 结算月份：结束
     */
    private Long monthOver;

    /**
     * 确认状态 ：待确认：0（默认）；已确认：1
     */
    private Integer status;

    /**
     *门店号集合
     */
    private Set<Long> shopNums;

    /**
     * 商户、门店号唯一id字段
     */
    private Long id;

}
