package cn.com.duiba.quanyi.center.api.param.user;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 支付宝ext
 * @author mybatis generator 
 * @date 2024-04-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class UserExtAliPaySearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17125456184344733L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 删除标识 （0：未删除，1：删除）默认为0
     */
    private Byte logicDelete;

    /**
     * 支付宝appId
     */
    private String appId;

    /**
     * 支付宝用户id
     */
    private String alipayUserId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 额外字段
     */
    private String extra;

    /**
     * 用户类型：1=小程序unionId、2=匿名券码、3-公众号静默openId
     */
    private Byte userType;
}