package cn.com.duiba.quanyi.center.api.remoteservice.insurance.cdtb;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.cdtb.InsuranceCdtbEquityDto;
import cn.com.duiba.quanyi.center.api.param.insurance.cdtb.InsuranceCdtbEquitySearchParam;
import java.util.List;

/**
 * 保险成都太保权益表
 * @author kjj mybatis generator 
 * @date 2024-09-25
 */
@AdvancedFeignClient
public interface RemoteInsuranceCdtbEquityService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保险成都太保权益集合
     */
    List<InsuranceCdtbEquityDto> selectPage(InsuranceCdtbEquitySearchParam param);

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 保险成都太保权益集合
     */
    List<InsuranceCdtbEquityDto> selectByPolicyNos(InsuranceCdtbEquitySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceCdtbEquitySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保险成都太保权益
     */
    InsuranceCdtbEquityDto selectById(Long id);

    /**
     * 新增
     * @param dto 保险成都太保权益
     * @return 执行结果
     */
    int insert(InsuranceCdtbEquityDto dto);

    /**
     * 批量插入
     * @param dtos 保险成都太保权益
     * @return 执行结果
     */
    List<InsuranceCdtbEquityDto> batchInsert(List<InsuranceCdtbEquityDto> dtos);

    /**
     * 更新
     * @param dto 保险成都太保权益
     * @return 影响行数
     */
    int update(InsuranceCdtbEquityDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}