/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.pay;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BankCardTypeEnum {
    CREDIT("credit", "\u4fe1\u7528\u5361"),
    DEBIT("debit", "\u501f\u8bb0\u5361"),
    CREDIT_DEBIT("debit_and_credit", "\u4fe1\u7528\u5361\u548c\u501f\u8bb0\u5361");

    private final String type;
    private final String desc;
    private static final Map<String, BankCardTypeEnum> ENUM_MAP;

    public static BankCardTypeEnum getByType(String type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private BankCardTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(BankCardTypeEnum.values()).collect(Collectors.toMap(BankCardTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    }
}

