package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.MeiTuanCouponDto;
import cn.com.duiba.quanyi.center.api.param.coupon.MeiTuanActivitySaveOrUpdateParam;
import cn.com.duiba.quanyi.center.api.param.coupon.MeiTuanCouponBatchUpdateCreatorParam;
import cn.com.duiba.quanyi.center.api.param.coupon.MeiTuanCouponSearchParam;

import java.util.List;

/**
 * 美团支付劵表
 * @author kjj mybatis generator 
 * @date 2024-09-14
 */
@AdvancedFeignClient
public interface RemoteMeiTuanCouponService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 美团支付劵集合
     */
    List<MeiTuanCouponDto> selectPage(MeiTuanCouponSearchParam param);

    /**
     * 根据条件查询
     * @param param 查询条件
     * @return 美团支付劵集合
     */
    List<MeiTuanCouponDto> selectNoPage(MeiTuanCouponSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(MeiTuanCouponSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 美团支付劵
     */
    MeiTuanCouponDto selectById(Long id);

    /**
     * 新增
     * @param dto 美团支付劵
     * @return 执行结果
     */
    int insert(MeiTuanCouponDto dto);

    /**
     * 更新
     * @param dto 美团支付劵
     * @return 影响行数
     */
    int update(MeiTuanCouponDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 新增或修改
     *
     * @param param
     * @return
     */
    Long saveOrUpdate(MeiTuanActivitySaveOrUpdateParam param);

    /**
     * 批量替换创建人
     *
     * @param param 参数
     * @return 影响行数
     */
    int batchUpdateCreator(MeiTuanCouponBatchUpdateCreatorParam param);
}