/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.report;

import cn.com.duiba.quanyi.center.api.param.bigdata.BigdataQueryFieldParam;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ColumnFormatTypeEnum {
    DEFAULT(1, "\u4e0d\u683c\u5f0f\u5316", bigDataParam -> bigDataParam.getFieldName() + " as \"" + bigDataParam.getAliasName() + "\""),
    DIVER_100_FLOAT(2, "\u9664100\u4fdd\u7559\u6d6e\u70b9\u65702\u4f4d", bigDataParam -> "round((" + bigDataParam.getFieldName() + "/100::numeric), 2) as \"" + bigDataParam.getAliasName() + "\""),
    TEXT(3, "\u6587\u672c\u683c\u5f0f", bigDataParam -> "concat('`'," + bigDataParam.getFieldName() + ") as \"" + bigDataParam.getAliasName() + "\""),
    DATETIME(4, "\u65e5\u671f\u683c\u5f0f", bigDataParam -> "to_char(" + bigDataParam.getFieldName() + ", 'YYYY-MM-DD HH24:MI:SS') as \"" + bigDataParam.getAliasName() + "\"");

    private final Integer type;
    private final String desc;
    private DuiBaBigDateParamBuilder builder;
    private static Map<Integer, ColumnFormatTypeEnum> calMap;

    public static ColumnFormatTypeEnum getFormatType(Integer type) {
        return calMap.get(type);
    }

    public String builder(BigdataQueryFieldParam bigDataParam) {
        return this.builder.builder(bigDataParam);
    }

    private ColumnFormatTypeEnum(Integer type, String desc, DuiBaBigDateParamBuilder builder) {
        this.type = type;
        this.desc = desc;
        this.builder = builder;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public DuiBaBigDateParamBuilder getBuilder() {
        return this.builder;
    }

    static {
        calMap = Arrays.stream(ColumnFormatTypeEnum.values()).collect(Collectors.toMap(ColumnFormatTypeEnum::getType, Function.identity()));
    }

    @FunctionalInterface
    static interface DuiBaBigDateParamBuilder {
        public String builder(BigdataQueryFieldParam var1);
    }
}

