package cn.com.duiba.quanyi.center.api.dto.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付宝立减金库存表
 *
 * @author kjj mybatis generator
 * @date 2023-09-22
 */
@Data
public class AlipayActivityStockDto implements Serializable {

    private static final long serialVersionUID = 16953655967875992L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 支付宝立减金主键, tb_alipay_activity.id
     */
    private Long alipayActivityId;

    /**
     * 总库存，根据总预算计算而来
     */
    private Long totalNum;

    /**
     * 已使用数量，业务中使用统计计数
     */
    private Long usedNum;

    /**
     * 该活动上已领取红包数量 比如:999代表该活上已被领取999个红包 请注意：该结果可能存在2个小时之内的时间延迟，特殊情况下可能延迟会更久
     */
    private Long receiveCount;

    /**
     * 该活动上已领取红包金额，分为单位 999代表已领取9.99元 请注意：该结果可能存在2个小时之内的时间延迟，特殊情况下可能延迟会更久
     */
    private Long receiveAmount;

    /**
     * 该活动上已核销红包数量 比如:888代表该活上所有领取的红包中已核销了888个红包 请注意：该结果可能存在2个小时之内的时间延迟，特殊情况下可能延迟会更久
     */
    private Long usedCount;

    /**
     * 该活动上已核销红包金额，分为单位 888代表已领取8.88元 请注意：该结果可能存在2个小时之内的时间延迟，特殊情况下可能延迟会更久
     */
    private Long usedAmount;

    /**
     * 该活动上已退款的红包总金额，分为单位 999代表总共退款9.99元 请注意：该结果可能存在2个小时之内的时间延迟，特殊情况下可能延迟会更久
     */
    private Long refundAmount;

    /**
     * 该活动上剩余红包金额，分为单位 888代表剩余8.88元 请注意：该结果可能存在2个小时之内的时间延迟，特殊情况下可能延迟会更久
     */
    private Long availableAmount;

    /**
     * 初始同步数据时，支付宝返回的该活动上已领取红包数量
     */
    private Long initReceiveCount;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}