/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.coupon;

import cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public enum AlipayDiscountTypeEnum {
    REDUCE("reduce", "\u6ee1\u7acb\u51cf"),
    SINGLE("single", "\u5b9a\u989d\u7acb\u51cf(\u5b9a\u989d\u6ee1\u51cf)"),
    DISCOUNT("discount", "\u6298\u6263\u7acb\u51cf"),
    RANDOM("random", "\u968f\u673a\u91d1\u989d\u7acb\u51cf(\u968f\u673a\u6ee1\u51cf)"),
    INTELLIGENT_ALGORITHM("intelligentAlgorithm", "\u667a\u80fd\u7acb\u51cf"),
    MULTI_STAGED_DISCOUNT("multiStagedDiscount", "\u591a\u9636\u68af\u7acb\u51cf");

    private final String type;
    private final String desc;

    public static Integer getByType(String discountType) {
        if (REDUCE.getType().equals(discountType) || SINGLE.getType().equals(discountType)) {
            return AmountTypeEnum.FIXED.getType();
        }
        if (DISCOUNT.getType().equals(discountType) || RANDOM.getType().equals(discountType) || INTELLIGENT_ALGORITHM.getType().equals(discountType) || MULTI_STAGED_DISCOUNT.getType().equals(discountType)) {
            return AmountTypeEnum.UNFIXED.getType();
        }
        return null;
    }

    public static Pair<Long, Long> getMinAmountAndMaxAmount(String discountType, String discountValue) {
        JSONObject jsonObject;
        JSONArray rangeInfoList;
        if (StringUtils.isEmpty((CharSequence)discountType) || StringUtils.isEmpty((CharSequence)discountValue)) {
            return null;
        }
        if (RANDOM.getType().equals(discountType) && (rangeInfoList = (jsonObject = JSON.parseObject((String)discountValue)).getJSONArray("rangeInfoList")) != null && !rangeInfoList.isEmpty()) {
            JSONObject rangeInfo = rangeInfoList.getJSONObject(0);
            Long minAmount = Long.valueOf(rangeInfo.getString("minAmount"));
            Long maxAmount = Long.valueOf(rangeInfo.getString("maxAmount"));
            return Pair.of((Object)minAmount, (Object)maxAmount);
        }
        if (INTELLIGENT_ALGORITHM.getType().equals(discountType) && (jsonObject = JSON.parseObject((String)discountValue)) != null) {
            Long minAmount = Long.valueOf(jsonObject.getString("minAmount"));
            Long maxAmount = Long.valueOf(jsonObject.getString("maxAmount"));
            return Pair.of((Object)minAmount, (Object)maxAmount);
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private AlipayDiscountTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }
}

