package cn.com.duiba.quanyi.center.api.param.qy.contract;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 聚宝盆合同数据统计
 * @author mybatis generator 
 * @date 2024-05-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ContractSummarySearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17159162073491697L;

    /**
     * 主键
     */
    private Long id;


    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 需求id
     */
    private Long demandId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 含服务费合同累计采购总额
     */
    private Long standardTotalPurchase;

    /**
     * 不含服务费累计采购总额
     */
    private Long totalPurchase;

    /**
     * 含服务费合同累计核销总额
     */
    private Long standardVerificationAmount;

    /**
     * 不含服务费合同累计核销金额
     */
    private Long verificationAmount;

    /**
     * 已开票金额
     */
    private Long invoicedAmount;

    /**
     * 已回款金额
     */
    private Long remittanceAmount;
}