package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.AlipayActivityDto;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayActivityBatchUpdateCreatorParam;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayActivityPageParam;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayActivitySaveOrUpdateParam;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayBindDemandGoodsParam;
import cn.com.duiba.quanyi.center.api.param.coupon.AlipayCouponAllocationParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteAlipayActivityService {
    /**
     * 根据主键查询支付宝立减金
     *
     * @param id
     * @return
     */
    AlipayActivityDto selectById(Long id);

    /**
     * 根据支付宝活动id查询支付宝立减金
     *
     * @param alipayActId 支付宝活动id
     * @return
     */
    AlipayActivityDto selectByActId(String alipayActId);

    /**
     * 根据支付宝立减金活动id批量查询
     *
     * @param alipayActIds 活动id
     * @return 支付宝立减金
     */
    List<AlipayActivityDto> selectByActIds(Set<String> alipayActIds);

    /**
     * 根据id批量查询
     *
     * @param idList
     * @return
     */
    Map<Long, AlipayActivityDto> selectByIdList(Set<Long> idList);

    /**
     * 根据需求ID查询
     *
     * @param demandId
     * @return
     */
    List<AlipayActivityDto> selectByDemandId(Long demandId);

    /**
     * 根据需求ID及skuId查询
     *
     * @param demandId
     * @param skuId
     * @return
     */
    List<AlipayActivityDto> selectByDemandSkuId(Long demandId, Long skuId);

    /**
     * 根据需求ID及skuId查询
     *
     * @param demandGoodsId 需求商品id
     * @param skuId    商品skuId
     * @return 支付宝立减金 列表
     */
    List<AlipayActivityDto> selectByDemandGoodsIdSkuId(Long demandGoodsId, Long skuId);

    /**
     * 分页查询
     *
     * @param param
     * @return
     */
    List<AlipayActivityDto> selectPage(AlipayActivityPageParam param);

    /**
     * 查询总数
     *
     * @param param
     * @return
     */
    long selectCount(AlipayActivityPageParam param);

    /**
     * 新增或修改
     *
     * @param param
     * @return
     */
    Long saveOrUpdate(AlipayActivitySaveOrUpdateParam param);

    /**
     * 绑定到需求商品
     *
     * @return
     */
    int bindDemandGoods(AlipayBindDemandGoodsParam param);

    /**
     * 批量绑定需求商品
     *
     * @param list 绑定参数
     * @return 影响行数
     */
    int batchBindDemandGoods(List<AlipayBindDemandGoodsParam> list);

    /**
     * 解除绑定
     *
     * @return
     */
    int unbindDemandGoods(Long id, Long demandGoodsId);

    /**
     * 批量解绑需求商品
     *
     * @param ids           主键
     * @param demandGoodsId 需求商品id
     * @return 影响行数
     */
    int batchUnbindDemandGoods(List<Long> ids, Long demandGoodsId);

    /**
     * 根据需求商品id查询绑定的批次号
     *
     * @param demandGoodsId
     * @return
     */
    List<AlipayActivityDto> findByDemandGoodsId(Long demandGoodsId);

    /**
     * 批量替换创建人
     *
     * @param param 参数
     * @return 影响行数
     */
    int batchUpdateCreator(AlipayActivityBatchUpdateCreatorParam param);

    /**
     * 查询创建人数量
     *
     * @param createOperatorId 创建人ID
     * @return 数量
     */
    long selectCreatorCount(Long createOperatorId);

    /**
     * 批次启用停用
     *
     * @param id 主键
     * @return 执行结果
     */
    int updateEnableStatus(Long id,Integer enableStatus);

    /**
     * 分配
     *
     * @param param 分配参数
     * @return 是否分配成功
     */
    boolean allocation(AlipayCouponAllocationParam param);

    /**
     * 批量更新
     *
     * @param alipayActivityDtos 参数
     * @return 结果
     */
    int batchUpdate(List<AlipayActivityDto> alipayActivityDtos);

    /**
     * 取消关联
     *
     * @param id 主键
     * @return 是否取消成功
     */
    boolean cancelAssociation(Long id);
}
