package cn.com.duiba.quanyi.center.api.enums.workflow;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/10/21 17:42
 */
@AllArgsConstructor
@Getter
public enum ApprovalStatusEnum {
    NOT_COMMIT(1, "待提交"), 
    COMMIT_FAIL(2, "提交失败"),
    RUNNING(3, "审核中"), 
    TERMINATED(4, "已撤回"), 
    REFUSE(5, "已打回"), 
    AGREE(6, "已通过"), 
    DELETE(7, "已删除"), 
    ;
    
    private final Integer status;
    
    private final String desc;
    
    private static final Map<Integer, ApprovalStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ApprovalStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param status 枚举值
     * @return 枚举
     */
    public static ApprovalStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
