package cn.com.duiba.quanyi.center.api.param.project;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 项目权限
 * @author mybatis generator 
 * @date 2024-10-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ProjectAuthSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17294988941291705L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 权限类型
     * {@link cn.com.duiba.quanyi.center.api.enums.project.ProjectAuthTypeEnum}
     */
    private Integer authType;

    /**
     * 有权限人sso adminId
     */
    private Long ssoAdminId;

    /**
     * 姓名
     */
    private String ssoName;

    /**
     * 创建人id
     */
    private Long createOperatorId;

    /**
     * 创建人名称
     */
    private String createOperatorName;
}