package cn.com.duiba.quanyi.center.api.param.project;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 项目
 * @author mybatis generator 
 * @date 2024-10-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ProjectSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17294988941151269L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 主键集合
     */
    private List<Long> ids;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 关联客户ID
     */
    private Long partnerId;

    /**
     * 商务负责人ID
     */
    private Long commerceManagerId;

    /**
     * 商务负责人姓名
     */
    private String commerceManagerName;

    /**
     * 运营负责人ID
     */
    private Long operationsManagerId;

    /**
     * 运营负责人姓名
     */
    private String operationsManagerName;

    /**
     * 创建人ID
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 审核状态
     * {@link cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum}
     */
    private Integer approvalStatus;

    /**
     * 审核状态集合
     * {@link cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum}
     */
    private List<Integer> approvalStatusList;

    /**
     * 项目交付形式
     */
    private String deliveryMethod;

    /**
     * 交付风险评估
     */
    private String deliveryRiskAssessment;

    /**
     * 结算风险评估
     */
    private String settlementRiskAssessment;
}