package cn.com.duiba.quanyi.center.api.remoteservice.project;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.project.ProjectGoodsDto;
import cn.com.duiba.quanyi.center.api.param.project.ProjectGoodsSearchParam;

import java.util.List;

/**
 * 项目商品表
 * @author kjj mybatis generator 
 * @date 2024-10-21
 */
@AdvancedFeignClient
public interface RemoteProjectGoodsService {

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<ProjectGoodsDto> selectPage(ProjectGoodsSearchParam param);

    /**
     * 不分页查询
     * @param param
     * @return
     */
    List<ProjectGoodsDto> selectNoPage(ProjectGoodsSearchParam param);

    /**
     * 查询总数
     * @param param
     * @return
     */
    long selectCount(ProjectGoodsSearchParam param);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    ProjectGoodsDto selectById(Long id);

    /**
     * 插入
     * @param dto 项目商品
     * @return
     */
    int insert(ProjectGoodsDto dto);

    /**
     * 批量插入
     * @param dtoList 项目商品集合
     * @return
     */
    int batchInsert(List<ProjectGoodsDto> dtoList);

    /**
     * 更新
     * @param dto 项目商品
     * @return
     */
    int update(ProjectGoodsDto dto);

    /**
     * 批量更新
     * @param dtoList 项目商品集合
     * @return
     */
    int batchUpdate(List<ProjectGoodsDto> dtoList);


}