package cn.com.duiba.quanyi.center.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum DemandTypeEnum {
    CONVENTION_DEMAND(0, "常规需求"),
    OFFLINE_DEMAND(1, "线下需求"),
    MOBILE_PAYMENT(2, "快捷支付"),
    ADVANCE_PAYMENT(3, "垫资"),
    VIRTUAL(4, "虚拟"),
    OBJECT(5, "实物"),
    ;
    private final Integer code;

    private final String desc;

    /**
     * 根据code获取描述
     * @param code
     * @return
     */
    public static String getDesc(Integer code) {
        for (DemandTypeEnum demandTypeEnum : values()) {
            if (demandTypeEnum.getCode().equals(code)) {
                return demandTypeEnum.getDesc();
            }
        }
        return null;
    }
}
