package cn.com.duiba.quanyi.center.api.remoteservice.project;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.project.ProjectDto;
import cn.com.duiba.quanyi.center.api.param.project.ProjectSaveOrUpdateParam;
import cn.com.duiba.quanyi.center.api.param.project.ProjectSearchParam;

import java.util.List;
import java.util.Set;

/**
 * 项目
 * @author kjj mybatis generator 
 * @date 2024-10-21
 */
@AdvancedFeignClient
public interface RemoteProjectService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 项目
     */
    ProjectDto selectById(Long id);

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 合作客户
     */
    List<ProjectDto> selectByIdList(Set<Long> ids);

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<ProjectDto> selectPage(ProjectSearchParam param);

    /**
     * 不分页查询
     * @param param
     * @return
     */
    List<ProjectDto> selectNoPage(ProjectSearchParam param);

    /**
     * 查询总数
     * @param param
     * @return
     */
    long selectCount(ProjectSearchParam param);

    /**
     * 新增
     * @param param
     * @return
     */

    long insert(ProjectSaveOrUpdateParam param);

    /**
     * 更新
     * @param param
     * @return
     */

    int update(ProjectSaveOrUpdateParam param);

}