package cn.com.duiba.quanyi.center.api.dto.demand;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 需求-付款信息
 * @author mybatis generator 
 * @date 2024-10-27
 */
@Data
public class DemandPaymentInfoDto implements Serializable {
     
    private static final long serialVersionUID = 17300036504549320L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer logicDelete;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 垫资-付款事由
     */
    private String paymentReason;

    /**
     * 垫资-付款金额
     */
    private Long paymentAmount;

    /**
     * 垫资-付款账户
     */
    private String paymentAccount;

    /**
     * 垫资-付款公司
     */
    private String paymentCompany;

    /**
     * 垫资-付款方式
     */
    private String paymentType;

    /**
     * 垫资-收款账户
     */
    private String receivingAccount;

    /**
     * 垫资-收款公司
     */
    private String receivingCompany;

    /**
     * 备注
     */
    private String remark;

    /**
     * 垫资-实际打款金额
     */
    private Long actualPaymentAmount;

    /**
     * 垫资，打款状态，1-待打款，2-已打款
     * @see cn.com.duiba.quanyi.center.api.enums.demand.DemandPaymentStatusEnum
     */
    private Integer paymentStatus;
}