package cn.com.duiba.quanyi.center.api.dto.project;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 项目商品表
 * @author mybatis generator 
 * @date 2024-10-21
 */
@Data
public class ProjectGoodsDto implements Serializable {
     
    private static final long serialVersionUID = 17294988941262477L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 项目主键, tb_project.id
     */
    private Long projectId;

    /**
     * 采购商品spuId
     */
    private Long purchaseSpuId;

    /**
     * 采购商品skuId
     */
    private Long purchaseSkuId;

    /**
     * 采购商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.PurchaseSpuTypeEnum
     */
    private Integer purchaseSpuType;

    /**
     * 供应商id
     */
    private Long supplierId;

    /**
     * 商品spuId
     */
    private Long spuId;

    /**
     * 商品规格Id
     */
    private Long skuId;

    /**
     * 商品类型
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;

    /**
     * 结算费率，百分数，支持小数点
     */
    private String settlementRate;

    /**
     * 结算方式，1.按核销结算,2.按订单交易成功,3.按采购结算
     */
    private Integer settlementMethod;

    /**
     * 售价
     */
    private Long settlementPrice;

    /**
     * 审核状态
     * {@link cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum}
     */
    private Integer approvalStatus;
}