package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 立减类型
 * reduce:满立减(满5元减3元)
 * random:随机立减(满10元随机立减1元到3元
 *
 * @see <a>https://opendocs.alipay.com/pre-apis/01trl0</>
 */
@Getter
@AllArgsConstructor
public enum AlipayDiscountTypeEnum {
    REDUCE("reduce", "满立减"),
    RANDOM("random", "随机立减"),
    ;

    private final String type;

    private final String desc;
}
