package cn.com.duiba.quanyi.center.api.enums.user;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 建行钉钉联合营销活动建行返回的用户类型
 *
 * @author zzy
 * @create 2023/11/21 22:48
 **/
@Getter
@AllArgsConstructor
public enum CcbDingtalkCstStatusEnum {
    NEW("S20", "新客已达标"),
    OLD("S30", "存量老客户"),
    ;
    /**
     * 类型
     */
    private final String status;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 根据type值解析
     *
     * @param status
     * @return
     */
    public static CcbDingtalkCstStatusEnum getByStatus(String status) {
        if (status == null || status.isEmpty()) {
            return null;
        }
        for (CcbDingtalkCstStatusEnum statusEnum : values()) {
            if (Objects.equals(status, statusEnum.status)) {
                return statusEnum;
            }
        }
        return null;
    }
}
