package cn.com.duiba.quanyi.center.api.enums.abc;

import cn.com.duiba.quanyi.center.api.enums.activity.ActivityDrawLimitCycleEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author nongfu
 * @Date 2024/12/10 19:46
 */
@AllArgsConstructor
@Getter
public enum AbcBillTaskEnum {


    INIT(0, "待对账"),
    INIT_STATUS(1, "对账推送中"),
    SUCCESS(2, "推送成功等待运营处理"),
    FAIL(3, "推送失败"),
    PERFECT(4, "完结");


    private final Integer batchState;

    private final String desc;


    public static AbcBillTaskEnum getEnumByBatchState(Integer batchState) {
        for (AbcBillTaskEnum taskEnum : values()) {
            if (Objects.equals(taskEnum.getBatchState(), batchState)) {
                return taskEnum;
            }
        }
        return null;
    }
}
