package cn.com.duiba.quanyi.center.api.param.invoice;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.google.common.collect.Lists;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.collections4.CollectionUtils;

/**
 * 开票申请
 * @author mybatis generator 
 * @date 2024-12-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InvoiceApplySearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17332067335552816L;

    /**
     * 主键id集合
     */
    private List<Long> ids;

    /**
     * 项目id集合
     */
    private List<Long> projectIds;

    /**
     * 主结算单名称
     */
    private Long mainSettlementId;

    /**
     * 创建人id
     */
    private Long createOperatorId;

    /**
     * 申请开始时间
     */
    private Date applyStartTime;

    /**
     * 申请结束时间
     */
    private Date applyEndTime;

    /**
     * 开票申请状态
     * {@link cn.com.duiba.quanyi.center.api.enums.settlement.InvoiceApplyStatusEnum}
     */
    private Integer invoiceApplyStatus;

    public void setProjectId(Long projectId) {
        if (projectId == null) {
            return;
        }
        if (this.projectIds == null) {
            this.projectIds = Lists.newArrayList(projectId);
        }
        this.projectIds.add(projectId);
    }
}