package cn.com.duiba.quanyi.center.api.param.mall.order;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 商城订单
 * @author mybatis generator 
 * @date 2024-05-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class MallOrderSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17166182119338019L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 商城订单编号
     */
    private String mallOrderNo;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 商城商品spuId
     */
    private Long mallSpuId;

    /**
     * 商城商品skuId
     */
    private Long mallSkuId;

    /**
     * 商品库spu类型
     */
    private Integer spuType;

    /**
     * 支付订单号
     */
    private String bizOrderNo;

    /**
     * 商品配置ID（入口位置）
     */
    private Long confId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 奖品ID
     */
    private Long prizeId;
}