package cn.com.duiba.quanyi.center.api.remoteservice.external;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.external.ExternalOrderChannelDto;
import cn.com.duiba.quanyi.center.api.param.external.ExternalOrderChannelSearchParam;
import java.util.List;

/**
 * 外部订单渠道
 * @author kjj mybatis generator 
 * @date 2024-12-03
 */
@AdvancedFeignClient
public interface RemoteExternalOrderChannelService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 外部订单渠道集合
     */
    List<ExternalOrderChannelDto> selectPage(ExternalOrderChannelSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ExternalOrderChannelSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 外部订单渠道
     */
    ExternalOrderChannelDto selectById(Long id);


    /**
     * 根据渠道类型查询
     * @param channelType 渠道类型
     * @return 外部订单渠道
     */
    ExternalOrderChannelDto selectByChannelType(Integer channelType);

    /**
     * 新增
     * @param dto 外部订单渠道
     * @return 执行结果
     */
    int insert(ExternalOrderChannelDto dto);

    /**
     * 更新
     * @param dto 外部订单渠道
     * @return 影响行数
     */
    int update(ExternalOrderChannelDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据主键ID列表批量查询
     * @param ids
     * @return
     */
    List<ExternalOrderChannelDto> selectByIds(List<Long> ids);
}