package cn.com.duiba.quanyi.center.api.remoteservice.external;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.external.ExternalOrderDto;
import cn.com.duiba.quanyi.center.api.dto.external.ExternalOrderExcelDto;
import cn.com.duiba.quanyi.center.api.param.external.ExternalOrderSearchParam;
import java.util.List;

/**
 * 外部订单
 * @author kjj mybatis generator 
 * @date 2024-12-03
 */
@AdvancedFeignClient
public interface RemoteExternalOrderService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 外部订单集合
     */
    List<ExternalOrderDto> selectPage(ExternalOrderSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ExternalOrderSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 外部订单
     */
    ExternalOrderDto selectById(Long id);

    /**
     * 新增
     * @param dto 外部订单
     * @return 执行结果
     */
    int insert(ExternalOrderDto dto);

    /**
     * 批量新增
     * @param list 外部订单
     * @return 执行结果
     */
    long batchInsert(List<ExternalOrderExcelDto> list);


    /**
     * 更新
     * @param dto 外部订单
     * @return 影响行数
     */
    int update(ExternalOrderDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}