package cn.com.duiba.quanyi.center.api.enums.external;

import cn.com.duiba.quanyi.center.api.enums.UploadBizTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;


/**
 * 外部订单渠道类型枚举
 */
@AllArgsConstructor
@Getter
public enum ExternalOrderChannelTypeEnum {

    JD_PAYMENT(1, "京东支付"),
    CQP_PAYMENT(2, "云闪付"),
    ALIPAY_DOLPHIN(3, "支付宝海豚"),
    ICBC_DC(4, "工行数币"),
    ABC_DC(5, "农行数币"),
    DOU_YIN_ADVANCE(6, "抖音垫资"),
    ;

    private final Integer status;

    private final String desc;

    public static ExternalOrderChannelTypeEnum getByStatus(Integer status) {
        for (ExternalOrderChannelTypeEnum typeEnum : values()) {
            if (typeEnum.getStatus().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static UploadBizTypeEnum getUploadBizTypeEnum(Integer status) {
        ExternalOrderChannelTypeEnum channelTypeEnum = ExternalOrderChannelTypeEnum.getByStatus(status);
        if (channelTypeEnum == null) {
            throw new IllegalArgumentException("未知的渠道类型");
        }
        switch (channelTypeEnum) {
            case JD_PAYMENT:
                return UploadBizTypeEnum.JD_PAYMENT_ORDER_RECORD_IMPORT;
            case CQP_PAYMENT:
                return UploadBizTypeEnum.CQP_PAYMENT_ORDER_RECORD_IMPORT;
            case ALIPAY_DOLPHIN:
                return UploadBizTypeEnum.ALIPAY_DOLPHIN_PAYMENT_ORDER_RECORD_IMPORT;
            case ICBC_DC:
                return UploadBizTypeEnum.ICBC_DC_PAYMENT_ORDER_RECORD_IMPORT;
            case ABC_DC:
                return UploadBizTypeEnum.ABC_DC_PAYMENT_ORDER_RECORD_IMPORT;
            case DOU_YIN_ADVANCE:
                return UploadBizTypeEnum.DOU_YIN_PAYMENT_ORDER_RECORD_IMPORT;
            default:
                throw new IllegalArgumentException("未知的渠道类型");
        }

    }

}
