package cn.com.duiba.quanyi.center.api.remoteservice.qy.abc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.abc.AbcBillRequestRecordDto;
import cn.com.duiba.quanyi.center.api.param.qy.abc.AbcBillRequestRecordSearchParam;
import java.util.List;

/**
 * 农总行任务执行子任务表
 * @author kjj mybatis generator 
 * @date 2024-12-10
 */
@AdvancedFeignClient
public interface RemoteAbcBillRequestRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 农总行任务执行子任务集合
     */
    List<AbcBillRequestRecordDto> selectPage(AbcBillRequestRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AbcBillRequestRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 农总行任务执行子任务
     */
    AbcBillRequestRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 农总行任务执行子任务
     * @return 执行结果
     */
    int insert(AbcBillRequestRecordDto dto);

    /**
     * 更新
     * @param dto 农总行任务执行子任务
     * @return 影响行数
     */
    int update(AbcBillRequestRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}