package cn.com.duiba.quanyi.center.api.remoteservice.insurance.equity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.activity.InsuranceTakeBaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.equity.InsuranceAdditionalEquityRecordDto;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceAdditionalEquityRecordSearchParam;
import java.util.List;

/**
 * 追加权益记录表
 * @author kjj mybatis generator 
 * @date 2024-05-22
 */
@AdvancedFeignClient
public interface RemoteInsuranceAdditionalEquityRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 追加权益记录集合
     */
    List<InsuranceAdditionalEquityRecordDto> selectPage(InsuranceAdditionalEquityRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InsuranceAdditionalEquityRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 追加权益记录
     */
    InsuranceAdditionalEquityRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 追加权益记录
     * @return 执行结果
     */
    int insert(InsuranceAdditionalEquityRecordDto dto);

    /**
     * 更新
     * @param dto 追加权益记录
     * @return 主键ID
     */
    InsuranceTakeBaseResultDto<Long> update(InsuranceAdditionalEquityRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 变更追加权益状态
     * @param id
     * @param auditStatus
     * @param operatorPhone
     * @return
     */
    InsuranceTakeBaseResultDto<Long> updateAuditStatus(Long id, int auditStatus, String operatorPhone);

    /**
     * 更新权益
     * @param dto
     * @return
     */
    InsuranceTakeBaseResultDto<Long> save(InsuranceAdditionalEquityRecordDto dto);


    /**
     * 根据权益ID查询
     * @param id 主键
     * @return 追加权益记录
     */
    InsuranceAdditionalEquityRecordDto selectByEquityId(Long id);


    /**
     * 根据权益ID查询
     * @param equityId 权益ID列表
     * @return 追加权益记录
     */
    List<InsuranceAdditionalEquityRecordDto> selectListByEquityIds(List<Long> equityId);

}