
package cn.com.duiba.quanyi.center.api.enums.activity;

import cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 支付类型
 *
 * @author zzy
 * @create 2023/10/11 11:32
 **/
@Getter
@AllArgsConstructor
public enum PayChannelEnum {
    WX_PAY(1, "微信支付", PayChannelTypeEnum.WX_LITE),
    CCB_ZJ_EYUAN_PAY(2, "浙江建行数币支付", PayChannelTypeEnum.CCB_PAY),
    ;

    private final Integer type;

    private final String desc;
    
    private final PayChannelTypeEnum payChannelTypeEnum;
    
    private static final Map<Integer, PayChannelEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PayChannelEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static PayChannelEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}