package cn.com.duiba.quanyi.center.api.enums.settlement;

import cn.com.duiba.quanyi.center.api.enums.bigdata.BigdataHologresTableEnum;
import cn.com.duiba.quanyi.center.api.enums.bigdata.QueryOperatorTypeEnum;
import cn.com.duiba.quanyi.center.api.param.bigdata.BigdataHologresDownloadParam;
import cn.com.duiba.quanyi.center.api.param.bigdata.BigdataQueryConditionParam;
import cn.com.duiba.quanyi.center.api.param.settlement.holo.SettlementHoloCreateParam;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author chenyongkun
 * @date 2024/11/29
 */
public enum HoloSettlementDimension {

    DP_RECORD(SettlementExcelDimension.DP.name(), (bigdataHologresDownloadParam, param) -> {
        List<BigdataQueryConditionParam> conditionParamList = Lists.newArrayList();
        BigdataQueryConditionParam conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList(String.valueOf(DateUtils.getDayNumber(param.getStartDate()))));
        conditionParam.setSymbol(QueryOperatorTypeEnum.GE.toString());
        conditionParamList.add(conditionParam);
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList(String.valueOf(DateUtils.getDayNumber(param.getEndDate()))));
        conditionParam.setSymbol(QueryOperatorTypeEnum.LE.toString());
        conditionParamList.add(conditionParam);
        //批次数据
        if(CollectionUtils.isNotEmpty(param.getSelectList())){
            conditionParam = new BigdataQueryConditionParam();
            conditionParam.setFieldName("(unique_mark, settlement_method)");
            List<Object> uniqueMarkList = new ArrayList<>();
            param.getSelectList().forEach(bean ->
                bean.getUniqueMarkList().forEach(uniqueMark -> uniqueMarkList.addAll(Lists.newArrayList(buildValue(uniqueMark, bean.getSettlementMethod()))))
            );
            conditionParam.setFieldType(2);
            conditionParam.setFieldValue(uniqueMarkList);
            conditionParam.setSymbol(QueryOperatorTypeEnum.IN.toString());
            conditionParamList.add(conditionParam);
        }
        bigdataHologresDownloadParam.setFilterConditions(conditionParamList);
        bigdataHologresDownloadParam.setTableName(BigdataHologresTableEnum.SETTLEMENT_ORDER_DP_BILL_DETAIL.name());
        bigdataHologresDownloadParam.setFileName(SettlementExcelDimension.DP.name());
    }),
    KM_RECORD(SettlementExcelDimension.KM.name(), (bigdataHologresDownloadParam, param) -> {
        List<BigdataQueryConditionParam> conditionParamList = Lists.newArrayList();
        BigdataQueryConditionParam conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList(String.valueOf(DateUtils.getDayNumber(param.getStartDate()))));
        conditionParam.setSymbol(QueryOperatorTypeEnum.GE.toString());
        conditionParamList.add(conditionParam);
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList(String.valueOf(DateUtils.getDayNumber(param.getEndDate()))));
        conditionParam.setSymbol(QueryOperatorTypeEnum.LE.toString());
        conditionParamList.add(conditionParam);
        //批次数据
        if(CollectionUtils.isNotEmpty(param.getSelectList())){
            conditionParam = new BigdataQueryConditionParam();
            conditionParam.setFieldName("(unique_mark, settlement_method)");
            List<Object> uniqueMarkList = new ArrayList<>();
            param.getSelectList().forEach(bean ->
                    bean.getUniqueMarkList().forEach(uniqueMark -> uniqueMarkList.addAll(Lists.newArrayList(buildValue(uniqueMark, bean.getSettlementMethod()))))
            );
            conditionParam.setFieldType(2);
            conditionParam.setFieldValue(uniqueMarkList);
            conditionParam.setSymbol(QueryOperatorTypeEnum.IN.toString());
            conditionParamList.add(conditionParam);
        }
        bigdataHologresDownloadParam.setFilterConditions(conditionParamList);
        bigdataHologresDownloadParam.setTableName(BigdataHologresTableEnum.SETTLEMENT_ORDER_KM_BILL_DETAIL.name());
        bigdataHologresDownloadParam.setFileName(SettlementExcelDimension.KM.name());
    }),
    OBJECT_RECORD(SettlementExcelDimension.OBJECT.name(), (bigdataHologresDownloadParam, param) -> {
        List<BigdataQueryConditionParam> conditionParamList = Lists.newArrayList();
        BigdataQueryConditionParam conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList(String.valueOf(DateUtils.getDayNumber(param.getStartDate()))));
        conditionParam.setSymbol(QueryOperatorTypeEnum.GE.toString());
        conditionParamList.add(conditionParam);
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList(String.valueOf(DateUtils.getDayNumber(param.getEndDate()))));
        conditionParam.setSymbol(QueryOperatorTypeEnum.LE.toString());
        conditionParamList.add(conditionParam);
        //批次数据
        if(CollectionUtils.isNotEmpty(param.getSelectList())){
            conditionParam = new BigdataQueryConditionParam();
            conditionParam.setFieldName("(unique_mark, settlement_method)");
            List<Object> uniqueMarkList = new ArrayList<>();
            param.getSelectList().forEach(bean ->
                    bean.getUniqueMarkList().forEach(uniqueMark -> uniqueMarkList.addAll(Lists.newArrayList(buildValue(uniqueMark, bean.getSettlementMethod()))))
            );
            conditionParam.setFieldType(2);
            conditionParam.setFieldValue(uniqueMarkList);
            conditionParam.setSymbol(QueryOperatorTypeEnum.IN.toString());
            conditionParamList.add(conditionParam);
        }
        bigdataHologresDownloadParam.setFilterConditions(conditionParamList);
        bigdataHologresDownloadParam.setTableName(BigdataHologresTableEnum.SETTLEMENT_ORDER_OBJECT_BILL_DETAIL.name());
        bigdataHologresDownloadParam.setFileName(SettlementExcelDimension.OBJECT.name());
    }),
    WX_RECORD(SettlementExcelDimension.WX.name(), (bigdataHologresDownloadParam, param) -> {
        List<BigdataQueryConditionParam> conditionParamList = Lists.newArrayList();
        BigdataQueryConditionParam conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList(String.valueOf(DateUtils.getDayNumber(param.getStartDate()))));
        conditionParam.setSymbol(QueryOperatorTypeEnum.GE.toString());
        conditionParamList.add(conditionParam);
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList(String.valueOf(DateUtils.getDayNumber(param.getEndDate()))));
        conditionParam.setSymbol(QueryOperatorTypeEnum.LE.toString());
        conditionParamList.add(conditionParam);
        //批次数据
        if(CollectionUtils.isNotEmpty(param.getSelectList())){
            conditionParam = new BigdataQueryConditionParam();
            conditionParam.setFieldName("(unique_mark, settlement_method, wx_bill_type)");
            List<Object> uniqueMarkList = new ArrayList<>();
            param.getSelectList().forEach(bean ->
                    bean.getUniqueMarkList().forEach(uniqueMark -> uniqueMarkList.addAll(Lists.newArrayList(buildWxValue(uniqueMark, bean.getSettlementMethod(), bean.getWxBillType()))))
            );
            conditionParam.setFieldType(2);
            conditionParam.setFieldValue(uniqueMarkList);
            conditionParam.setSymbol(QueryOperatorTypeEnum.IN.toString());
            conditionParamList.add(conditionParam);
        }
        bigdataHologresDownloadParam.setFilterConditions(conditionParamList);
        bigdataHologresDownloadParam.setTableName(BigdataHologresTableEnum.SETTLEMENT_ORDER_WX_BILL_DETAIL.name());
        bigdataHologresDownloadParam.setFileName(SettlementExcelDimension.WX.name());
    }),
    ALIPAY_RECORD(SettlementExcelDimension.ALIPAY.name(), (bigdataHologresDownloadParam, param) -> {
        List<BigdataQueryConditionParam> conditionParamList = Lists.newArrayList();
        BigdataQueryConditionParam conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList(String.valueOf(DateUtils.getDayNumber(param.getStartDate()))));
        conditionParam.setSymbol(QueryOperatorTypeEnum.GE.toString());
        conditionParamList.add(conditionParam);
        conditionParam = new BigdataQueryConditionParam();
        conditionParam.setFieldName("date_partition");
        conditionParam.setFieldValue(Lists.newArrayList(String.valueOf(DateUtils.getDayNumber(param.getEndDate()))));
        conditionParam.setSymbol(QueryOperatorTypeEnum.LE.toString());
        conditionParamList.add(conditionParam);
        //批次数据
        if(CollectionUtils.isNotEmpty(param.getSelectList())){
            conditionParam = new BigdataQueryConditionParam();
            conditionParam.setFieldName("(unique_mark, settlement_method)");
            List<Object> uniqueMarkList = new ArrayList<>();
            param.getSelectList().forEach(bean ->
                    bean.getUniqueMarkList().forEach(uniqueMark -> uniqueMarkList.addAll(Lists.newArrayList(buildValue(uniqueMark, bean.getSettlementMethod()))))

            );
            conditionParam.setFieldType(2);
            conditionParam.setFieldValue(uniqueMarkList);
            conditionParam.setSymbol(QueryOperatorTypeEnum.IN.toString());
            conditionParamList.add(conditionParam);
        }
        bigdataHologresDownloadParam.setFilterConditions(conditionParamList);
        bigdataHologresDownloadParam.setTableName(BigdataHologresTableEnum.SETTLEMENT_ORDER_ALIPAY_BILL_DETAIL.name());
        bigdataHologresDownloadParam.setFileName(SettlementExcelDimension.ALIPAY.name());
    });

    private String dimension;

    private DuiBaBigDateParamBuilder builder;

    public String getDimension() {
        return dimension;
    }


    HoloSettlementDimension(String dimension, DuiBaBigDateParamBuilder builder) {
        this.dimension = dimension;
        this.builder = builder;
    }

    public void builder(BigdataHologresDownloadParam bigDataParam, SettlementHoloCreateParam engineParam) {
        builder.builder(bigDataParam, engineParam);
    }


    @FunctionalInterface
    interface DuiBaBigDateParamBuilder {
        void builder(BigdataHologresDownloadParam bigDataParam, SettlementHoloCreateParam engineParam);
    }

    private static Map<String, HoloSettlementDimension> calMap;

    static {
        calMap = Arrays.stream(HoloSettlementDimension.values())
                .collect(Collectors.toMap(HoloSettlementDimension::getDimension, Function.identity()));
    }

    public static HoloSettlementDimension getHoloSettlementDimension(String dimension) {
        return calMap.get(dimension);
    }

    private static String buildValue(String uniqueMark, Integer settlementMethod){
        return "('"+ uniqueMark+"'," + settlementMethod+")";
    }

    private static String buildWxValue(String uniqueMark, Integer settlementMethod, Integer wxBillType){
        return "('"+ uniqueMark+"'," + settlementMethod + "," +wxBillType +")";
    }
}
