package cn.com.duiba.quanyi.center.api.param.external;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 外部订单
 * @author mybatis generator 
 * @date 2024-12-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ExternalOrderSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17332135616312843L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 渠道ID
     */
    private Long channelId;

    /**
     * 外部订单批次ID
     */
    private Long externalOrderCouponId;

    /**
     * 外部订单批次ID集合
     */
    private List<Long> externalOrderCouponIds;

    /**
     * 三方活动ID
     */
    private String thirdActivityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 钱包号
     */
    private String walletNum;

    /**
     * 交易号
     */
    private String transactionNo;

    /**
     * 交易时间
     */
    private Date transactionTime;

    /**
     * 交易时间-开始时间
     */
    private Date transactionStartTime;

    /**
     * 交易时间-结束时间
     */
    private Date transactionEndTime;

    /**
     * 交易类型
     */
    private Integer transactionType;

    /**
     * 优惠金额
     */
    private Long discountAmount;

    /**
     * 创建人
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 其他字段信息
     */
    private String otherJson;
}