package cn.com.duiba.quanyi.center.api.remoteservice.bigdata;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.bigdata.BigdataDownloadResultDto;
import cn.com.duiba.quanyi.center.api.dto.goods.GoodsOrderResultDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.activity.InsuranceActivityTakeSplitDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.activity.InsuranceTakeBaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.activity.InsuranceTakeThresholdDto;
import cn.com.duiba.quanyi.center.api.param.bigdata.BigdataHologresDownloadParam;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceTakeParam;
import cn.com.duiba.quanyi.center.api.param.insurance.InsuranceTakeRetryParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 大数据Hologres下载
 * @author lizhi
 * @date 2024/3/6 10:24
 */
@AdvancedFeignClient
public interface RemoteHologresService {

    /**
     * 数据下载
     * @param param 兑换参数
     * @return 是否提交成功
     */
    boolean asyncDownload(BigdataHologresDownloadParam param);

    /**
     * 数据下载
     * @param param 兑换参数
     * @return 是否提交成功
     */
    boolean asyncDownloadList(List<BigdataHologresDownloadParam> param);
    /**
     * 数据下载结果
     * @param taskId 任务ID
     * @return 是否提交成功
     */
    BigdataDownloadResultDto<String> downloadResult(String taskId);

    /**
     * 数据下载拆分并压缩Zip文件
     * @param param
     * @return
     */
    boolean asyncZipDownload(BigdataHologresDownloadParam param);

    /**
     * 查询统计行数
     * @param param
     * @return
     */
    Long selectCountNum(BigdataHologresDownloadParam param);

    /**
     * 导出CSV，并返回本地地址
     * @param param
     * @param folderName
     * @return
     */
    String exportCsvFile(BigdataHologresDownloadParam param, String folderName);
}
