package cn.com.duiba.quanyi.center.api.remoteservice.api;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.api.ApiOrderDto;
import cn.com.duiba.quanyi.center.api.param.api.ApiOrderMngSearchParam;
import cn.com.duiba.quanyi.center.api.param.api.ApiOrderSearchParam;

import java.util.List;
import java.util.Set;

/**
 * API供货订单表
 * @author kjj mybatis generator
 * @date 2023-12-21
 */
@AdvancedFeignClient
public interface RemoteApiOrderService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return API供货订单集合
     */
    List<ApiOrderDto> selectPage(ApiOrderSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ApiOrderSearchParam param);


    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return API供货订单集合
     */
    List<ApiOrderDto> selectMngPage(ApiOrderMngSearchParam param);

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return API供货订单集合
     */
    Long selectMngCount(ApiOrderMngSearchParam param);

    /**
     * 根据三方单号查询数据
     * @param apiJoinId API加盟商ID
     * @param thirdOrderNo 三方单号
     * @return API供货订单
     */
    ApiOrderDto selectByThirdOrderNo(Long apiJoinId ,String thirdOrderNo);

    /**
     * 根据三方单号批量查询数据
     * @param apiJoinId
     * @param thirdOrderNos
     * @return
     */
    List<ApiOrderDto> selectByThirdOrderNos(Long apiJoinId , Set<String> thirdOrderNos);

    /**
     * 根据兑吧订单号查询
     *
     * @param mainOrderNum 兑吧订单号
     * @return 结果
     */
    ApiOrderDto selectByMainOrderNum(String mainOrderNum);
}