package cn.com.duiba.quanyi.center.api.param.insurance;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * @author: LuHui
 * @date: 2024/7/16 17:39
 * @description:
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class InsuranceLandEquityEsSearchParam extends PageQuery {

    private static final long serialVersionUID = 399617822010719326L;
    /**
     * 公司id
     */
    private Long companyId;
    /**
     * 机构ID
     */
    private Long institutionId;
    /**
     * 坐席登录账号主键
     */
    private Long salesmanId;

    /**
     * 待领人代码
     */
    private String userCode;

    /**
     * 发放人姓名
     */
    private String takeName;

    /**
     * 发放人手机号
     */
    private String takePhone;

    /**
     * 卡号
     */
    private String cardNo;

    /**
     * 身份证号
     */
    private String identityCard;

    /**
     * 发放状态：1-待发放，2-比对成功未发放 3-发放成功，4-发放失败
     */
    private Integer takeStatus;
    /**
     * 订单创建时间开始时间
     */
    private Date startTime;

    /**
     * 订单创建时间结束时间
     */
    private Date endTime;
    /**
     * 发放状态集合 1:待发放 3:发放成功 2,4发放失败
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsuranceLandEquityGrantStatusEnum
     */
    private List<Integer> takeStatusList;
}
