package cn.com.duiba.quanyi.center.api.remoteservice.settlement.receive;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.receive.ReceivedPaymentInvoiceRefDto;

/**
 * 回款与发票关联关系
 * @author kjj mybatis generator 
 * @date 2024-12-11
 */
@AdvancedFeignClient
public interface RemoteReceivedPaymentInvoiceRefService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 回款与发票关联关系
     */
    ReceivedPaymentInvoiceRefDto selectById(Long id);

    /**
     * 新增
     * @param dto 回款与发票关联关系
     * @return 执行结果
     */
    int insert(ReceivedPaymentInvoiceRefDto dto);

    /**
     * 更新
     * @param dto 回款与发票关联关系
     * @return 影响行数
     */
    int update(ReceivedPaymentInvoiceRefDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}