package cn.com.duiba.quanyi.center.api.param.bank.hzbank;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: LuHui
 * @date: 2024/4/7 15:59
 * @description:
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class NotifySftpParam extends BaseRequestParam implements Serializable {
    private static final long serialVersionUID = -8546596599889900431L;

    /**
     * 通知时间 yyyy-MM-dd HH:mm:ss
     */
    private Date noticeTime;
    /**
     * 类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.bank.hzbank.NotifyTypeEnum
     */
    private String type;
    /**
     * 对账起始时间（对账类型必传字段）yyyy-MM-dd HH:mm:ss
     */
    private Date billStartTime;
    /**
     * 对账结束时间（对账类型必传字段）yyyy-MM-dd HH:mm:ss
     */
    private Date billEndTime;
    /**
     * 权益货品维护为ZIP⽂件， 对账为CSV⽂件,每个⽂件名不超过64位
     */
    private List<String> fileName;

    /**
     * 唯一批次号
     */
    private String batchNo;
}
