package cn.com.duiba.quanyi.center.api.dto.activity;

import cn.com.duiba.quanyi.center.api.enums.BooleanEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.ActivityLimitConfigEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.TemplateWhiteStandEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author nongfu
 * @Date 2024/7/11 16:07
 */
@Data
public class ActivityTemplateWhiteDto implements Serializable {
    private static final long serialVersionUID = 533580528882033653L;

    /**
     * 白名单发奖限制，0-无，1开启限制
     */
    private Integer whiteStatus;
    /**
     * 0 默认值 1 客户号 2 手机号
     */
    private Integer limitType = TemplateWhiteStandEnum.COMMON_STANDARD.getType();

    /**
     * 0 发奖用户 1 需要基础白名单
     */
    private Integer baseUserStatus = BooleanEnum.FALSE.getCode();
    /**
     * 白名单发奖规则集合
     */
    private List<ActivityTemplateWhiteDetailDto> whiteDetailDtoList;

    /**
     * 领取周期限制开关 默认活动周期
     * @see ActivityLimitConfigEnum
     */
    private Integer whiteQueryLimitType = ActivityLimitConfigEnum.FOREVER.getType();
}
