package cn.com.duiba.quanyi.center.api.dto.qystatistic;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 支付宝核销数据统计表
 * @author mybatis generator 
 * @date 2024-08-16
 */
@Data
public class AlipayActWriteOffStatisticDataDto implements Serializable {
     
    private static final long serialVersionUID = 17237888613616314L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 支付宝活动ID
     */
    private String alipayActId;

    /**
     * 预算金额
     */
    private String budgetAmount;

    /**
     * 配置日期
     */
    private Date configDate;

    /**
     * 核销金额
     */
    private String verifiedAmount;

    /**
     * 退款金额
     */
    private String refundAmount;

    /**
     * 核销净额
     */
    private String netVerifiedAmount;

    /**
     * 余额（不含退款)
     */
    private String balanceExcludingRefund;

    /**
     * 余额（含退款)
     */
    private String balanceIncludingRefund;

    /**
     * 总应收账款
     */
    private String totalReceivables;

    /**
     * 已打款金额
     */
    private String paidAmount;

    /**
     * 统计月份
     */
    private LocalDate statisticMonth;

    /**
     * 统计类型,0-按月,1-截止到当前的数据
     */
    private Integer statisticType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 已发放金额
     */
    private String distributedAmount;

    /**
     * 未发放金额
     */
    private String notDistributedAmount;

    /**
     * 总库存数
     */
    private Long totalStockCount;

    /**
     * 已发放数
     */
    private Long grantedCount;

    /**
     * 已核销数
     */
    private Long verifiedCount;

    /**
     * 剩余库存数
     */
    private Long remainingStockCount;

    /**
     * 需求预算
     */
    private String demandBudget;

    /**
     * 资金使用率
     */
    private String fundUseRate;

    /**
     * 结算价
     */
    private String settlementRate;

    /**
     * 运营负责人
     */
    private String operatorManagerName;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 支付宝商户号
     */
    private String configEntity;

    /**
     * 批次状态
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AlipayActivityStatusEnum
     */
    private String alipayActStatus;

    /**
     * 配置主体
     */
    private String settlementEntity;

}