package cn.com.duiba.quanyi.center.api.param.qy.alipay;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 支付宝立减金配置预算变更记录表
 * @author mybatis generator 
 * @date 2024-08-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class AlipayCouponConfigBudgetChangRecordSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 1724295751675564L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 支付宝活动ID
     */
    private String alipayActId;

    /**
     * 变更金额 单位分
     */
    private Long changeAmount;

    /**
     * 预算金额，单位分
     */
    private Long budgetAmount;

    /**
     * 变更日期
     */
    private LocalDate changeDate;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 变更日期(不等于)
     */
    private Date changeDateNotIn;
}