package cn.com.duiba.quanyi.center.api.remoteservice.invoice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.invoice.InvoiceHistoryDto;
import cn.com.duiba.quanyi.center.api.param.invoice.InvoiceHistorySearchParam;
import java.util.List;

/**
 * 历史开票
 * @author kjj mybatis generator 
 * @date 2025-01-09
 */
@AdvancedFeignClient
public interface RemoteInvoiceHistoryService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 历史开票集合
     */
    List<InvoiceHistoryDto> selectPage(InvoiceHistorySearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(InvoiceHistorySearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 历史开票
     */
    InvoiceHistoryDto selectById(Long id);

    /**
     * 新增
     * @param dto 历史开票
     * @return 执行结果
     */
    int insert(InvoiceHistoryDto dto);

    /**
     * 更新
     * @param dto 历史开票
     * @return 影响行数
     */
    int update(InvoiceHistoryDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}